# Sid Meier's Civilization 4 
# Copyright Firaxis Games 2005 
# 
# Additional information: http://session.apolyton.net/modiki/index.php?title=Main_Page

from __future__ import division
import os
import wx
import wx.lib.imagebrowser as ib
import Image
import BMPtoWBSConverter186

# Scenario file for BMP to WBS Converter Version 18.6
# Author: Gabriele "Rhye" Trovato
# This file contains all the info the BMPConverter will put in Civ4WorldBuilderSave headers


class ScenarioClass:

        iDefaultWidth = 35
        iDefaultHeight = 26        
        iDefaultRiverSensitivity = 5        # 1 to 7, higher means FEWER river plots are put on the map based upon the RiverMap - 5 is recommended    
        iDefaultCoastsAssignment = 3
        iDefaultFloodPlainsAssignment = 3
        iDefaultXWrapping = 0
        iDefaultYWrapping = 0
        iDefaultNumberOfCivs = 3
        HeightMapPath = "Empty.bmp"
        TerrainMapPath = "Empty.bmp"
        FeatureMapPath = "Empty.bmp"
        RiverMapPath = "Empty.bmp"
        BonusMapPath = "Empty.bmp"


        #Fog of war

        dltRevealPlots = {}

        dltRevealPlots[0] =    []
        dltRevealPlots[1] =    []
        dltRevealPlots[2] =    []
        dltRevealPlots[3] =    []
        dltRevealPlots[4] =    []
        dltRevealPlots[5] =    []
        dltRevealPlots[6] =    []
        dltRevealPlots[7] =    []
        dltRevealPlots[8] =    []
        dltRevealPlots[9] =    []
        dltRevealPlots[10] =    []
        dltRevealPlots[11] =    []
        dltRevealPlots[12] =    []
        dltRevealPlots[13] =    []
        dltRevealPlots[14] =    []
        dltRevealPlots[15] =    []
        dltRevealPlots[16] =    []
        dltRevealPlots[17] =    []


        #Terrain improvements
        
        dltFBoats =	[]
        dltWBoats =	[]
        dltMine =	[]
        dltQuarry =	[]
        dltCamp =	[]
        dltFarm =	[]
        dltPlantation =	[]
        dltWinery =	[]
        dltPasture =	[]
        dltWindmill =	[]
        dltLumbermill =	[]
        dltWatermill =	[]
        dltFort =	[]
        dltOPlatform =	[]
        dltWell =	[]
        dltWorkshop =	[]
        dltCottage =	[]
        dltHamlet =	[]
        dltVillage =	[]
        dltTown =	[]
        dltRuins =	[]
        dltGoodyHut =	[]
        dltRoad =	[]
        dltRailroad =	[]

        
	def TerrainChanges(self, bmpc, iPlotX, iPlotY):

                # Scenario-specific changes to the map
                bmpc.DebugLogging("No further terrain changes\n")
                

	def WriteStartingPlots(self, bmpc, iPlotX, iPlotY):

                bmpc.DebugLogging("No starting plot entries\n")


	def WriteCitiesUnits(self, bmpc, iPlotX, iPlotY):

		# Write cities and units
                bmpc.DebugLogging("No cities or units\n")


	def getExtraWBSText_GameSettings(self):
		WBSText = "Version=11 \
		\nBeginGame \
		\n\tSpeed=GAMESPEED_NORMAL \
		\n\tCalendar=CALENDAR_DEFAULT \
		\n\tGameTurn=0 \
		\n\tStartYear=-4000 \
		\nEndGame"
		return WBSText
	    
	def getExtraWBSText_Diplomacy(self):

                #teams
                WBSText = ""
                
                return WBSText



	def getExtraWBSText_Civs(self):
            
                #players
                WBSText = "\nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=0\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=1\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=2\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=3\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=4\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=5\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=6\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=7\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=8\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=9\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=10\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=11\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=12\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=13\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=14\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=15\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=16\nEndPlayer \
                        \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=17\nEndPlayer"
                
                return WBSText

	def getExtraWBSText_WorldSettings(self, bmpConverter):
                WBSText = "\n\tworld size=WORLDSIZE_STANDARD \
                \n\tclimate=CLIMATE_TEMPERATE \
                \n\tsealevel=SEALEVEL_MEDIUM \
                \n\tnum plots written=%d\nEndMap\n" %(bmpConverter.iSizeX * bmpConverter.iSizeY)
		return WBSText
	
bmpc = BMPtoWBSConverter186.runBMPConvertToWBSApp(ScenarioClass())
