# Sid Meier's Civilization 4 
# Copyright Firaxis Games 2005 
# 
# Additional information: http://session.apolyton.net/modiki/index.php?title=Main_Page

from __future__ import division
import os
import wx
import wx.lib.imagebrowser as ib
import Image
import BMPtoWBSConverter186

# Scenario file for BMP to WBS Converter Version 18.6
# Author: Gabriele "Rhye" Trovato
# This file contains all the info the BMPConverter will put in Civ4WorldBuilderSave headers


class ScenarioClass:

        iDefaultWidth = 35
        iDefaultHeight = 26        
        iDefaultRiverSensitivity = 5
        iDefaultCoastsAssignment = 3
        iDefaultFloodPlainsAssignment = 1
        iDefaultXWrapping = 0
        iDefaultYWrapping = 0
        iDefaultNumberOfCivs = 3
        HeightMapPath = "Default_H.bmp"
        TerrainMapPath = "Default_T.bmp"
        FeatureMapPath = "Default_F.bmp"
        RiverMapPath = "Default_R.bmp"
        BonusMapPath = "Default_B.bmp"


        #Fog of war

        dltRevealPlots = {}

        dltRevealPlots[0] =    []
        dltRevealPlots[1] =    []
        dltRevealPlots[2] =    []
        dltRevealPlots[3] =    []
        dltRevealPlots[4] =    []
        dltRevealPlots[5] =    []
        dltRevealPlots[6] =    []
        dltRevealPlots[7] =    []
        dltRevealPlots[8] =    []
        dltRevealPlots[9] =    []
        dltRevealPlots[10] =    []
        dltRevealPlots[11] =    []
        dltRevealPlots[12] =    []
        dltRevealPlots[13] =    []
        dltRevealPlots[14] =    []
        dltRevealPlots[15] =    []
        dltRevealPlots[16] =    []
        dltRevealPlots[17] =    []
        

        #Terrain improvements
        
        dltFBoats =	[]
        dltWBoats =	[]
        dltMine =	[]
        dltQuarry =	[]
        dltCamp =	[]
        dltFarm =	[]
        dltPlantation =	[]
        dltWinery =	[]
        dltPasture =	[]
        dltWindmill =	[]
        dltLumbermill =	[]
        dltWatermill =	[]
        dltFort =	[]
        dltOPlatform =	[]
        dltWell =	[]
        dltWorkshop =	[]
        dltCottage =	[]
        dltHamlet =	[]
        dltVillage =	[]
        dltTown =	[]
        dltRuins =	[]
        dltGoodyHut =	[   (1, 7),
                            (3, 20),
                            (9, 9),
                            (13, 20),
                            (23, 11),
                            (30, 8)
                         ]
        dltRoad =	[]
        dltRailroad =	[]

        
	def TerrainChanges(self, bmpc, iPlotX, iPlotY):

                # Scenario-specific changes to the map

                if (iPlotX == 19 and iPlotY == 9) or \
                        (iPlotX == 19 and iPlotY == 10) or \
                        (iPlotX == 20 and iPlotY == 9):
                                bmpc.aaiPlotTypes[iPlotX][iPlotY] = 1

                if (iPlotX == 18 and iPlotY == 10):
                                bmpc.aasTerrainTypes[iPlotX][iPlotY] = 'TERRAIN_PLAINS'

                

	def WriteStartingPlots(self, bmpc, iPlotX, iPlotY):

                bmpc.DebugLogging("No starting plot entries\n")


	def WriteCitiesUnits(self, bmpc, iPlotX, iPlotY):

		# Write cities and units

                if iPlotX == 14 and iPlotY == 10:
                        bmpc.OutputFile.write("\tBeginUnit \
                        \n\t\tUnitType=UNIT_ARCHER, UnitOwner=0 \
                        \n\t\tLevel=4, Experience=0 \
                        \n\tEndUnit\n")
                        bmpc.OutputFile.write("\tRouteType=ROUTE_ROAD\n\tBeginCity \
                        \n\t\tCityOwner=0 \
                        \n\t\tCityName=Rome \
                        \n\t\tCityPopulation=6 \
                        \n\t\tPlayer0Culture=100 \
                        \n\t\tPlayer2Culture=10 \
                        \n\t\tBuildingType=BUILDING_PALACE \
                        \n\t\tBuildingType=BUILDING_COLOSSEUM \
                        \n\t\tBuildingType=BUILDING_CASTLE \
                        \n\t\tBuildingType=BUILDING_OBELISK \
                        \n\t\tBuildingType=BUILDING_MARKET \
                        \n\t\tBuildingType=BUILDING_COURTHOUSE \
                        \n\t\tBuildingType=BUILDING_CHRISTIAN_CATHEDRAL \
                        \n\t\tBuildingType=BUILDING_CHRISTIAN_MONASTERY \
                        \n\t\tReligionType=RELIGION_CHRISTIANITY \
                        \n\tEndCity\n")

                if iPlotX == 19 and iPlotY == 10:
                        bmpc.OutputFile.write("\tRouteType=ROUTE_ROAD\n\tBeginCity \
                        \n\t\tCityOwner=1 \
                        \n\t\tCityName=Paris \
                        \n\t\tCityPopulation=5 \
                        \n\t\tPlayer1Culture=100 \
                        \n\t\tBuildingType=BUILDING_PALACE \
                        \n\t\tBuildingType=BUILDING_LIBRARY \
                        \n\t\tBuildingType=BUILDING_MARKET \
                        \n\t\tBuildingType=BUILDING_ISLAMIC_TEMPLE \
                        \n\t\tBuildingType=BUILDING_ISLAMIC_CATHEDRAL \
                        \n\t\tBuildingType=BUILDING_ISLAMIC_SHRINE \
                        \n\t\tReligionType=RELIGION_ISLAM \
                        \n\t\tReligionType=RELIGION_JUDAISM \
                        \n\t\tHolyCityReligionType=RELIGION_ISLAM \
                        \n\tEndCity\n")
                        
                if iPlotX == 9 and iPlotY == 18:
                        bmpc.OutputFile.write("\tBeginUnit \
                        \n\t\tUnitType=UNIT_SETTLER, UnitOwner=2 \
                        \n\t\tLevel=4, Experience=0 \
                        \n\tEndUnit\n")
                        bmpc.OutputFile.write("\tBeginUnit \
                        \n\t\tUnitType=UNIT_WORKER, UnitOwner=2 \
                        \n\t\tLevel=4, Experience=0 \
                        \n\tEndUnit\n")
                        
                if iPlotX == 20 and iPlotY == 22:
                        bmpc.OutputFile.write("\tBeginUnit \
                        \n\t\tUnitType=UNIT_SPEARMAN, UnitOwner=18 \
                        \n\t\tLevel=4, Experience=0 \
                        \n\t\tUnitAIType=UNITAI_ATTACK \
                        \n\tEndUnit\n")


	def getExtraWBSText_GameSettings(self):
		WBSText = "Version=11\
\nBeginGame\
\n\tSpeed=GAMESPEED_NORMAL\
\n\tCalendar=CALENDAR_MONTHS\
\n\tOption=GAMEOPTION_NO_CITY_RAZING\
\n\tMPOption=MPOPTION_SIMULTANEOUS_TURNS\
\n\tVictory=VICTORY_TIME\
\n\tVictory=VICTORY_CONQUEST\
\n\tVictory=VICTORY_DOMINATION\
\n\tGameTurn=0\
\n\tStartYear=1500\
\n\tMaxTurns=100\
\n\tDescription=This is just an example\
\n\tModPath=\
\nEndGame"
		return WBSText
	    
	def getExtraWBSText_Diplomacy(self):

                #teams
                WBSText = "\nBeginTeam \
                        \n\tTech=TECH_MINING \
                        \n\tTech=TECH_BRONZE_WORKING \
			\n\tAtWar=1 \
			\n\tRevealMap=1 \
                        \nEndTeam \
                        \nBeginTeam \
                        \n\tTech=TECH_MYSTICISM \
                        \n\tTech=TECH_THE_WHEEL \
			\n\tAtWar=0 \
                        \nEndTeam \
                        \nBeginTeam \
                        \n\tTech=TECH_AGRICULTURE \
                        \n\tTech=TECH_MINING \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam \
                        \nBeginTeam \
                        \nEndTeam"
                
                return WBSText



	def getExtraWBSText_Civs(self):
            
                #players
                WBSText = "\nBeginPlayer \
                \n\tTeam=0 \
                \n\tLeaderType=LEADER_MAO_ZEDONG \
                \n\tCivType=CIVILIZATION_CHINA \
                \n\tCivDesc=Italian Empire \
                \n\tCivShortDesc=Italy \
                \n\tCivAdjective=Italian \
                \n\tLeaderName=Victor Emmanuel II \
                \n\tFlagDecal=Art/Interface/TeamColor/FlagDECAL_Laurels.dds \
                \n\tColor=PLAYERCOLOR_BLUE \
                \n\tArtStyle=ARTSTYLE_EUROPEAN \
                \n\tStartingEra=ERA_RENAISSANCE \
                \n\tCityList=Rome \
                \n\tCityList=Milan \
                \n\tCityList=Turin \
                \n\tCityList=Florence \
                \n\tCityList=Venice \
                \n\tCityList=Pisa \
                \n\tCityList=Livorno \
                \n\tCityList=Naples \
                \n\tCityList=Bologna \
                \n\tCityList=Siena \
                \n\tCityList=Palermo \
                \n\tPlayableCiv=1 \
                \n\tStartingGold=30 \
                \n\tStateReligion=RELIGION_CHRISTIANITY \
                \n\tCivicOption=CIVICOPTION_GOVERNMENT, Civic=CIVIC_DESPOTISM \
                \n\tCivicOption=CIVICOPTION_LEGAL, Civic=CIVIC_BARBARISM \
                \n\tCivicOption=CIVICOPTION_LABOR, Civic=CIVIC_SLAVERY \
                \n\tCivicOption=CIVICOPTION_ECONOMY, Civic=CIVIC_DECENTRALIZATION \
                \n\tCivicOption=CIVICOPTION_RELIGION, Civic=CIVIC_PAGANISM \
                \n\tHandicap=HANDICAP_NOBLE \
                \n\tAttitudePlayer=1, AttitudeExtra=5 \
                \nEndPlayer \
                \nBeginPlayer \
                \n\tTeam=1 \
                \n\tLeaderType=LEADER_NAPOLEON \
                \n\tCivType=CIVILIZATION_FRANCE \
                \n\tPlayableCiv=0 \
                \n\tStartingGold=30 \
                \n\tHandicap=HANDICAP_EMPEROR \
                \n\tAttitudePlayer=0, AttitudeExtra=-10 \
                \nEndPlayer \
                \nBeginPlayer \
                \n\tTeam=2 \
                \n\tLeaderType=LEADER_GENGHIS_KHAN \
                \n\tCivType=CIVILIZATION_GERMANY \
                \n\tLeaderName=Bismarck \
                \n\tPlayableCiv=0 \
                \n\tStartingGold=30 \
                \n\tMinorNationStatus=1 \
                \n\tHandicap=HANDICAP_NOBLE \
                \nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=3\nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=4\nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=5\nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=6\nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=7\nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=8\nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=9\nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=10\nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=11\nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=12\nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=13\nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=14\nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=15\nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=16\nEndPlayer \
                \nBeginPlayer\n\tLeaderType=NONE\n\tCivType=NONE\n\tTeam=17\nEndPlayer"
                
                return WBSText

	def getExtraWBSText_WorldSettings(self, bmpConverter):
                WBSText = "\n\ttop latitude=50 \
                \n\tbottom latitude=30 \
                \n\tworld size=WORLDSIZE_TINY \
                \n\tclimate=CLIMATE_TEMPERATE \
                \n\tsealevel=SEALEVEL_MEDIUM \
                \n\tnum plots written=%d\nEndMap\n" %(bmpConverter.iSizeX * bmpConverter.iSizeY)
		return WBSText
	
bmpc = BMPtoWBSConverter186.runBMPConvertToWBSApp(ScenarioClass())
